/**
 * Copyright (C) 2012, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Mueller, christian.linke@bmw.de BMW 2011,2012
 *
 * \file
 * For further information see http://www.genivi.org/.
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL. PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN
 */
#if !defined(EA_52591199_D6BE_451e_92F8_032DA5493EF4__INCLUDED_)
#define EA_52591199_D6BE_451e_92F8_032DA5493EF4__INCLUDED_

#include <vector>
#include <string>
#include "audiomanagertypes.h"
namespace am {
class CAmDbusWrapper;
class CAmSocketHandler;
}


#include "audiomanagertypes.h"

#define CommandReceiveVersion "2.0"
namespace am {
  /**
   * The interface towards the Controlling Instance (e.g HMI). It handles the communication towards the HMI and other system
   * components who need to interact with the audiomanagement.
   * There are two rules that have to be kept in mind when implementing against this interface:\n
   * \warning
   * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
   * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS CALL THAT EXPECTS A RETURN VALUE.\n
   * \details
   * Violation these rules may lead to unexpected behavior! Nevertheless you can implement thread safe by using the deferred-
   * call pattern described on the wiki which also helps to implement calls that are forbidden.\n
   * For more information, please check CAmSerializer
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:24
   */
  class IAmCommandReceive
  {

  public:
    IAmCommandReceive() {

    }

    virtual ~IAmCommandReceive() {

    }

    /**
     * This function returns the version of the interface.
     *
     * @param version
     */
    virtual void getInterfaceVersion(std::string& version) const =0;
    /**
     * connects a source to sink
     * @return E_OK on success, E_NOT_POSSIBLE on failure, E_ALREADY_EXISTS if the connection does already exists
     *
     * @param sourceID
     * @param sinkID
     * @param mainConnectionID
     */
    virtual am_Error_e connect(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID) =0;
    /**
     * disconnects a mainConnection
     * @return E_OK on successes, E_NON_EXISTENT if the connection does not exist, E_NOT_POSSIBLE on error.
     *
     * @param mainConnectionID
     */
    virtual am_Error_e disconnect(const am_mainConnectionID_t mainConnectionID) =0;
    /**
     * sets the volume for a sink
     * @return E_OK on success, E_UNKOWN on error, E_OUT_OF_RANGE in case the value is out of range
     *
     * @param sinkID    the sink
     * @param volume    the volume
     */
    virtual am_Error_e setVolume(const am_sinkID_t sinkID, const am_mainVolume_t volume) =0;
    /**
     * This function is used to increment or decrement the current volume for a sink.
     * @return E_OK on success, E_UNKNOWN on error and E_OUT_OF_RANGE if the value is not in the given volume range.
     *
     * @param sinkID
     * @param volumeStep    indicated the number of steps that should be incremented or decremented. Positive values here
     * inkrement, negative values decrement
     */
    virtual am_Error_e volumeStep(const am_sinkID_t sinkID, const int16_t volumeStep) =0;
    /**
     * sets the mute state of a sink
     * @return E_OK on success, E_UNKNOWN on error. If the mute state is already the desired one, the Daemon will return E_OK.
     *
     * @param sinkID
     * @param muteState
     */
    virtual am_Error_e setSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState) =0;
    /**
     * This method is used to set sound properties, e.g. Equalizer Values. Since the capabilities of the system can differ,
     * the exact key value pairs can be extended in each product
     * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in case of an error
     *
     * @param soundProperty
     * @param sinkID
     */
    virtual am_Error_e setMainSinkSoundProperty(const am_MainSoundProperty_s& soundProperty, const am_sinkID_t sinkID) =0;
    /**
     * This method is used to set sound properties, e.g. Equalizer Values. Since the capabilities of the system can differ,
     * the exact key value pairs can be extended in each product
     * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in case of an error
     *
     * @param soundProperty
     * @param sourceID
     */
    virtual am_Error_e setMainSourceSoundProperty(const am_MainSoundProperty_s& soundProperty, const am_sourceID_t sourceID) =0;
    /**
     * is used to set a specific system property.
     * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in case of an error
     *
     * @param property    the property that shall be set
     */
    virtual am_Error_e setSystemProperty(const am_SystemProperty_s& property) =0;
    /**
     * returns the actual list of MainConnections
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listConnections    returns a list of all connections
     */
    virtual am_Error_e getListMainConnections(std::vector<am_MainConnectionType_s>& listConnections) const =0;
    /**
     * returns the actual list of Sinks
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listMainSinks    the list of the sinks
     */
    virtual am_Error_e getListMainSinks(std::vector<am_SinkType_s>& listMainSinks) const =0;
    /**
     * returns the actual list of Sources
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listMainSources    the list of sources
     */
    virtual am_Error_e getListMainSources(std::vector<am_SourceType_s>& listMainSources) const =0;
    /**
     * This is used to retrieve all source sound properties related to a source. Returns a vector of the sound properties and
     * values as pair
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param sinkID
     * @param listSoundProperties
     */
    virtual am_Error_e getListMainSinkSoundProperties(const am_sinkID_t sinkID, std::vector<am_MainSoundProperty_s>& listSoundProperties) const =0;
    /**
     * This is used to retrieve all source sound properties related to a source.
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param sourceID
     * @param listSourceProperties
     */
    virtual am_Error_e getListMainSourceSoundProperties(const am_sourceID_t sourceID, std::vector<am_MainSoundProperty_s>& listSourceProperties) const =0;
    /**
     * This is used to retrieve SourceClass Information of all source classes
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listSourceClasses
     */
    virtual am_Error_e getListSourceClasses(std::vector<am_SourceClass_s>& listSourceClasses) const =0;
    /**
     * This is used to retrieve SinkClass Information of all sink classes
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listSinkClasses
     */
    virtual am_Error_e getListSinkClasses(std::vector<am_SinkClass_s>& listSinkClasses) const =0;
    /**
     * Retrieves a complete list of all systemProperties.
     * @return E_OK on success, E_DATABASE_ERROR on error
     *
     * @param listSystemProperties
     */
    virtual am_Error_e getListSystemProperties(std::vector<am_SystemProperty_s>& listSystemProperties) const =0;
    /**
     * returns the delay in ms that the audiopath for the given mainConnection has
     * @return E_OK on success, E_NOT_POSSIBLE if timing information is not yet retrieved, E_DATABASE_ERROR on read error on
     * the database
     *
     * @param mainConnectionID
     * @param delay
     */
    virtual am_Error_e getTimingInformation(const am_mainConnectionID_t mainConnectionID, am_timeSync_t& delay) const =0;
    /**
     * this function is used to retrieve a pointer to the dBusConnectionWrapper
     * @return E_OK if pointer is valid, E_UKNOWN if AudioManager was compiled without DBus Support
     *
     * @param dbusConnectionWrapper    This is a wrapper class that is needed to keep dbus inclusions away from the interface.
     * The DBusWrapperClass will return the pointer to the DbusConnection call (getDBusConnection)
     */
    virtual am_Error_e getDBusConnectionWrapper(CAmDbusWrapper*& dbusConnectionWrapper) const =0;
    /**
     * This function returns the pointer to the socketHandler. This can be used to integrate socket-based activites like
     * communication with the mainloop of the AudioManager.
     * returns E_OK if pointer is valid, E_UNKNOWN in case AudioManager was compiled without socketHandler support,
     *
     * @param socketHandler
     */
    virtual am_Error_e getSocketHandler(CAmSocketHandler*& socketHandler) const =0;
    /**
     * asynchronous confirmation of setCommandReady.
     *
     * @param handle    the handle that was handed over by setCommandReady
     * @param error    E_OK if the ready command succeeded. E_UNKNOWN if an error happened.
     */
    virtual void confirmCommandReady(const uint16_t handle, const am_Error_e error) =0;
    /**
     * asynchronous confirmation of setCommandRundown
     *
     * @param handle    the handle that was given via setCommandRundown
     * @param error    E_OK if the ready command succeeded. E_UNKNOWN if an error happened.
     */
    virtual void confirmCommandRundown(const uint16_t handle, const am_Error_e error) =0;
    /**
     * Retrieves the list of MainNotifications for a sink. Does not return the possible ones.
     *
     * @param sinkID    The sinkID
     * @param listMainNotificationConfigurations
     */
    virtual am_Error_e getListMainSinkNotificationConfigurations(const am_sinkID_t sinkID, std::vector<am_NotificationConfiguration_s>& listMainNotificationConfigurations) const =0;
    /**
     * Retrieves the list of MainNotifications for a source. Does not return the possible ones.
     *
     * @param sourceID    The sourceID
     * @param listMainNotificationConfigurations
     */
    virtual am_Error_e getListMainSourceNotificationConfigurations(const am_sourceID_t sourceID, std::vector<am_NotificationConfiguration_s>& listMainNotificationConfigurations) const =0;
    /**
     * sets a MainNotificationConfiuration. This can be used to turn on an off notifications an to change the mode of the
     * configuration.
     * @return E_OK on success, E_NON_EXISTENT if sinkID does not exists, E_DATABASE_ERROR on error
     *
     * @param sinkID    The sinkID of the MainNotification to be changed
     * @param mainNotificationConfiguration    The MainNotifiication that needs to be set
     */
    virtual am_Error_e setMainSinkNotificationConfiguration(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
    /**
     * sets a MainNotificationConfiuration. This can be used to turn on an off notifications an to change the mode of the
     * configuration.
     * @return E_OK on success, E_NON_EXISTENT if sourceID does not exists, E_DATABASE_ERROR on error
     *
     * @param sourceID    The sourceID of the MainNotification to be changed
     * @param mainNotificationConfiguration    The MainNotifiication that needs to be set
     */
    virtual am_Error_e setMainSourceNotificationConfiguration(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;

  };
}
#endif // !defined(EA_52591199_D6BE_451e_92F8_032DA5493EF4__INCLUDED_)
